package main

import (
	"github.com/veandco/go-sdl2/sdl"
)

type FadeInFadeOutState uint8

const (
	FADING_IN FadeInFadeOutState = iota
	FADING_OUT
	FADING_STOPPED
)

type FaceInFadeOut struct {
	text   *Text
	speed  float32
	alpha  float32
	state  FadeInFadeOutState
	onStop func()
}

func NewFadeInFadeOut(text *Text, speed float32, onStop func()) *FaceInFadeOut {
	ff := new(FaceInFadeOut)
	ff.text = text
	ff.speed = speed
	ff.alpha = 1
	ff.state = FADING_IN
	ff.onStop = onStop
	return ff
}

func (ff *FaceInFadeOut) Update(deltaTime float32) {
	switch ff.state {
	case FADING_IN:
		ff.alpha += ff.speed * deltaTime
		if ff.alpha >= 255.0 {
			ff.state = FADING_OUT
		}
	case FADING_OUT:
		ff.alpha -= ff.speed * deltaTime
		if ff.alpha <= 1.0 {
			ff.state = FADING_STOPPED
			if ff.onStop != nil {
				ff.onStop()
			}
		}
	}
}

func (ff *FaceInFadeOut) DrawCenter(renderer *sdl.Renderer, x, y int32) {
	if ff.state != FADING_STOPPED {
		ff.text.DrawCenter(renderer, x, y, uint8(ff.alpha))
	}
}
